/*
Standard vertex transform shader for skinned models.
Supports position, normals, uv, tangets, bitangents and color.
Skin support with weights and joints.
Applies mirroring plane to user clip plane 0
*/
#version 430

//Standard vertex attributes, set to the default locations
layout(location = 0) in vec4 in_position;
layout(location = 1) in vec3 in_normal;
layout(location = 2) in vec2 in_uv;
layout(location = 3) in vec3 in_tangent;
layout(location = 4) in vec3 in_bitangent;
layout(location = 5) in vec4 in_color;
layout(location = 6) in vec4 in_weight;
layout(location = 7) in uvec4 in_joint;

//Uniform block for global matrices
#pragma lz append("lzsystem/shaders/generic/globalTransforms.glsl")

//Skin
layout(std140, binding = 1) uniform skin {
	mat4 joint[256];
};

//Fragment pass attributes
out VSOut {
	vec4 position_view;
	vec4 position_world;
	vec3 normal;
	vec3 tangent;
	vec3 bitangent;
	vec2 uv;
} vsoutput;

void main() {
	//Go through all weights to calculate the skin matrix
	mat4 wskin = mat4(0);
	for(int i=0; i<4; i++)
		wskin += in_weight[i] * joint[in_joint[i]];

	//Standard transform of attributes. 
	vsoutput.position_world = model * wskin * in_position;
	//Skin matrix in view space
	wskin = vm * wskin;
	//Parameters in view space
	vsoutput.normal = mat3(wskin) * in_normal;
	vsoutput.tangent = mat3(wskin) * in_tangent;
	vsoutput.bitangent = mat3(wskin) * in_bitangent;
	vsoutput.position_view = wskin * in_position;
	vsoutput.uv = in_uv;

	//The distance to the plane, to set the custom clip plane
	gl_ClipDistance[0] = dot(vsoutput.position_world.xyz,mirrorPlane.xyz) + mirrorPlane.w;

	gl_Position = projection * vsoutput.position_view;

}
